
#include "stdafx.h"

#include <shellapi.h>
#include "D3DApplication.h"

int APIENTRY _tWinMain( _In_ HINSTANCE hInstance,
						_In_opt_ HINSTANCE hPrevInstance,
						_In_ LPTSTR    lpCmdLine,
						_In_ int       nCmdShow )
{
	UNREFERENCED_PARAMETER( hPrevInstance );
	UNREFERENCED_PARAMETER( nCmdShow );

	LPWSTR *szArglist;
	int nArgs;
	szArglist = CommandLineToArgvW( lpCmdLine, &nArgs );

	// small hack to handle only "real" command line parameters
	// if no command line parameter is specified, szArgList[0] is the command with which the program is invoked
	// we skip this here
	if( wcscmp( lpCmdLine, L"" ) == 0 )
	{
		nArgs = 0;
	}

	if( nArgs != 2 )
	{
		printf( "d3d_wb_sample.exe image warping_and_blending.dds\n" );
		printf( "\timage: an image file represents the content\n" );
		printf( "\twarping_and_blending.dds: the dds export file\n" );
		return 1;
	}

	BOOL ok = FALSE;
	int retVal = 1;

	D3DApplication app;
	ok = app.InitInstance( hInstance, nArgs, szArglist );
	LocalFree( szArglist );
	
	if( ok )
	{
		retVal = app.Run();
	}

	app.Shutdown();

	return retVal;
}
