//--------------------------------------------------------------------------------------
// File: shaders.fx
//
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texture_0 : register( t0 ); // 
Texture2D texture_1 : register( t1 ); // warping/blending

SamplerState sampler_0 : register( s0 );

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos : POSITION;
    float2 Tex : TEXCOORD0;
};

struct PS_INPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output = (PS_INPUT)0;
    output.Pos = input.Pos;
    output.Tex = input.Tex;
    return output;
}

float4 PS( PS_INPUT input) : SV_Target
{
    float4 lookup = texture_1.Sample( sampler_0, input.Tex.xy );
	float4 output = texture_0.Sample( sampler_0, float2( lookup.x, 1.0 - lookup.y ) );

	float3 c = float3( output.z, output.y, output.x );

	float bla = lookup.w;
	float blend = lookup.z;
	float Gamma = 2.2;
	float3 result = pow( abs( pow( abs( c ), float3( Gamma, Gamma, Gamma ) ) ) * blend * (1 - bla) + bla, 1.0 / Gamma );

	return float4( result, 1.0 );
}
