#ifndef APPLICATION_H
#define APPLICATION_H

#include <Windows.h>
#include "Logger.h"

class Application
{
public:
	Application();
	virtual ~Application();

	BOOL InitInstance( HINSTANCE hInstance, int argc, LPWSTR *argv );
	virtual void Shutdown();

	virtual int Run();

public:
	void Log( const char* msg );
	void Log( const wchar_t* msg );
	void LogEx( const char* fmt, ... );
	void LogEx( const wchar_t* fmt, ... );

	virtual BOOL HandleKeyDown( WPARAM wParam, LPARAM lParam );

protected:
	virtual BOOL LoadConfiguration();
	virtual BOOL SetupInstance( int argc, LPWSTR *argv );

	BOOL RegisterWindowClass( WNDCLASSEX* wc );

protected:
	// windows stuff
	HINSTANCE m_hInstance;
	ATOM m_classAtom;

	// logging
	Logger *m_logfile;
};

#endif // APPLICATION_H
